package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  ClientRequestToken,
  ReportGeneratorName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLicenseManagerReportGeneratorRequest(
    licenseManagerReportGeneratorArn: String,
    reportGeneratorName: ReportGeneratorName,
    `type`: Iterable[io.github.vigoo.zioaws.licensemanager.model.ReportType],
    reportContext: io.github.vigoo.zioaws.licensemanager.model.ReportContext,
    reportFrequency: io.github.vigoo.zioaws.licensemanager.model.ReportFrequency,
    clientToken: ClientRequestToken,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest = {
    import UpdateLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
      .builder()
      .licenseManagerReportGeneratorArn(
        licenseManagerReportGeneratorArn: java.lang.String
      )
      .reportGeneratorName(reportGeneratorName: java.lang.String)
      .typeWithStrings(`type`.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .reportContext(reportContext.buildAwsValue())
      .reportFrequency(reportFrequency.buildAwsValue())
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
      .wrap(buildAwsValue())
}
object UpdateLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .UpdateLicenseManagerReportGeneratorRequest(
          licenseManagerReportGeneratorArnValue,
          reportGeneratorNameValue,
          typeValue,
          reportContextValue.editable,
          reportFrequencyValue.editable,
          clientTokenValue,
          descriptionValue.map(value => value)
        )
    def licenseManagerReportGeneratorArnValue: String
    def reportGeneratorNameValue: ReportGeneratorName
    def typeValue: List[io.github.vigoo.zioaws.licensemanager.model.ReportType]
    def reportContextValue
        : io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly
    def reportFrequencyValue
        : io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly
    def clientTokenValue: ClientRequestToken
    def descriptionValue: Option[String]
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseManagerReportGeneratorArnValue)
    def reportGeneratorName: ZIO[Any, Nothing, ReportGeneratorName] =
      ZIO.succeed(reportGeneratorNameValue)
    def `type`: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.ReportType
    ]] = ZIO.succeed(typeValue)
    def reportContext: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly
    ] = ZIO.succeed(reportContextValue)
    def reportFrequency: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly
    ] = ZIO.succeed(reportFrequencyValue)
    def clientToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientTokenValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest.ReadOnly {
    override def licenseManagerReportGeneratorArnValue: String =
      impl.licenseManagerReportGeneratorArn(): String
    override def reportGeneratorNameValue: ReportGeneratorName =
      impl.reportGeneratorName(): ReportGeneratorName
    override def typeValue
        : List[io.github.vigoo.zioaws.licensemanager.model.ReportType] = impl
      .`type`()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.ReportType.wrap(item)
      }
      .toList
    override def reportContextValue
        : io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.ReportContext
        .wrap(impl.reportContext())
    override def reportFrequencyValue
        : io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency
        .wrap(impl.reportFrequency())
    override def clientTokenValue: ClientRequestToken =
      impl.clientToken(): ClientRequestToken
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
  ): io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest.ReadOnly =
    new Wrapper(impl)
}
