package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  BoxBoolean,
  BoxLong
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLicenseConfigurationRequest(
    licenseConfigurationArn: String,
    licenseConfigurationStatus: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus
    ] = None,
    licenseRules: Option[Iterable[String]] = None,
    licenseCount: Option[BoxLong] = None,
    licenseCountHardLimit: Option[BoxBoolean] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    productInformationList: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ProductInformation]
    ] = None,
    disassociateWhenNotFound: Option[BoxBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest = {
    import UpdateLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest
      .builder()
      .licenseConfigurationArn(licenseConfigurationArn: java.lang.String)
      .optionallyWith(licenseConfigurationStatus.map(value => value.unwrap))(
        _.licenseConfigurationStatus
      )
      .optionallyWith(
        licenseRules.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.licenseRules)
      .optionallyWith(licenseCount.map(value => value: java.lang.Long))(
        _.licenseCount
      )
      .optionallyWith(
        licenseCountHardLimit.map(value => value: java.lang.Boolean)
      )(_.licenseCountHardLimit)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        productInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productInformationList)
      .optionallyWith(
        disassociateWhenNotFound.map(value => value: java.lang.Boolean)
      )(_.disassociateWhenNotFound)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .UpdateLicenseConfigurationRequest(
          licenseConfigurationArnValue,
          licenseConfigurationStatusValue.map(value => value),
          licenseRulesValue.map(value => value),
          licenseCountValue.map(value => value),
          licenseCountHardLimitValue.map(value => value),
          nameValue.map(value => value),
          descriptionValue.map(value => value),
          productInformationListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          disassociateWhenNotFoundValue.map(value => value)
        )
    def licenseConfigurationArnValue: String
    def licenseConfigurationStatusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus
    ]
    def licenseRulesValue: Option[List[String]]
    def licenseCountValue: Option[BoxLong]
    def licenseCountHardLimitValue: Option[BoxBoolean]
    def nameValue: Option[String]
    def descriptionValue: Option[String]
    def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]]
    def disassociateWhenNotFoundValue: Option[BoxBoolean]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConfigurationArnValue)
    def licenseConfigurationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus
    ] = AwsError.unwrapOptionField(
      "licenseConfigurationStatus",
      licenseConfigurationStatusValue
    )
    def licenseRules: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def licenseCount: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, AwsError, BoxBoolean] = AwsError
      .unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def productInformationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "productInformationList",
      productInformationListValue
    )
    def disassociateWhenNotFound: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField(
        "disassociateWhenNotFound",
        disassociateWhenNotFoundValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationRequest.ReadOnly {
    override def licenseConfigurationArnValue: String =
      impl.licenseConfigurationArn(): String
    override def licenseConfigurationStatusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus
    ] = scala
      .Option(impl.licenseConfigurationStatus())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationStatus
          .wrap(value)
      )
    override def licenseRulesValue: Option[List[String]] = scala
      .Option(impl.licenseRules())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def licenseCountValue: Option[BoxLong] =
      scala.Option(impl.licenseCount()).map(value => value: BoxLong)
    override def licenseCountHardLimitValue: Option[BoxBoolean] =
      scala.Option(impl.licenseCountHardLimit()).map(value => value: BoxBoolean)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = scala
      .Option(impl.productInformationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ProductInformation
            .wrap(item)
        }.toList
      )
    override def disassociateWhenNotFoundValue: Option[BoxBoolean] = scala
      .Option(impl.disassociateWhenNotFound())
      .map(value => value: BoxBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest
  ): io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
