package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait TokenType {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.TokenType
}
object TokenType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.TokenType
  ): io.github.vigoo.zioaws.licensemanager.model.TokenType = value match {
    case software.amazon.awssdk.services.licensemanager.model.TokenType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.TokenType.REFRESH_TOKEN =>
      val r = REFRESH_TOKEN
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.TokenType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.TokenType =
      software.amazon.awssdk.services.licensemanager.model.TokenType.UNKNOWN_TO_SDK_VERSION
  }
  case object REFRESH_TOKEN
      extends io.github.vigoo.zioaws.licensemanager.model.TokenType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.TokenType =
      software.amazon.awssdk.services.licensemanager.model.TokenType.REFRESH_TOKEN
  }
}
