package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  Arn,
  ISO8601DateTime
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TokenData(
    tokenId: Option[String] = None,
    tokenType: Option[String] = None,
    licenseArn: Option[String] = None,
    expirationTime: Option[ISO8601DateTime] = None,
    tokenProperties: Option[Iterable[String]] = None,
    roleArns: Option[Iterable[Arn]] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.TokenData = {
    import TokenData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.TokenData
      .builder()
      .optionallyWith(tokenId.map(value => value: java.lang.String))(_.tokenId)
      .optionallyWith(tokenType.map(value => value: java.lang.String))(
        _.tokenType
      )
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.String))(
        _.expirationTime
      )
      .optionallyWith(
        tokenProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tokenProperties)
      .optionallyWith(
        roleArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.roleArns)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.TokenData.wrap(buildAwsValue())
}
object TokenData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.TokenData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.TokenData =
      io.github.vigoo.zioaws.licensemanager.model.TokenData(
        tokenIdValue.map(value => value),
        tokenTypeValue.map(value => value),
        licenseArnValue.map(value => value),
        expirationTimeValue.map(value => value),
        tokenPropertiesValue.map(value => value),
        roleArnsValue.map(value => value),
        statusValue.map(value => value)
      )
    def tokenIdValue: Option[String]
    def tokenTypeValue: Option[String]
    def licenseArnValue: Option[String]
    def expirationTimeValue: Option[ISO8601DateTime]
    def tokenPropertiesValue: Option[List[String]]
    def roleArnsValue: Option[List[Arn]]
    def statusValue: Option[String]
    def tokenId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tokenId", tokenIdValue)
    def tokenType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tokenType", tokenTypeValue)
    def licenseArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def expirationTime: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("expirationTime", expirationTimeValue)
    def tokenProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
    def roleArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("roleArns", roleArnsValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.TokenData
  ) extends io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly {
    override def tokenIdValue: Option[String] =
      scala.Option(impl.tokenId()).map(value => value: String)
    override def tokenTypeValue: Option[String] =
      scala.Option(impl.tokenType()).map(value => value: String)
    override def licenseArnValue: Option[String] =
      scala.Option(impl.licenseArn()).map(value => value: String)
    override def expirationTimeValue: Option[ISO8601DateTime] =
      scala.Option(impl.expirationTime()).map(value => value: ISO8601DateTime)
    override def tokenPropertiesValue: Option[List[String]] = scala
      .Option(impl.tokenProperties())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def roleArnsValue: Option[List[Arn]] = scala
      .Option(impl.roleArns())
      .map(value =>
        value.asScala.map { item =>
          item: Arn
        }.toList
      )
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.TokenData
  ): io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly =
    new Wrapper(impl)
}
