package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.ResourceType
  ): io.github.vigoo.zioaws.licensemanager.model.ResourceType = value match {
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_INSTANCE =>
      val r = EC2_INSTANCE
      r
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_HOST =>
      val r = EC2_HOST
      r
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_AMI =>
      val r = EC2_AMI
      r
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.RDS =>
      val r = RDS
      r
    case software.amazon.awssdk.services.licensemanager.model.ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE =>
      val r = SYSTEMS_MANAGER_MANAGED_INSTANCE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_INSTANCE
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_INSTANCE
  }
  case object EC2_HOST
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_HOST
  }
  case object EC2_AMI
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.EC2_AMI
  }
  case object RDS
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.RDS
  }
  case object SYSTEMS_MANAGER_MANAGED_INSTANCE
      extends io.github.vigoo.zioaws.licensemanager.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ResourceType =
      software.amazon.awssdk.services.licensemanager.model.ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE
  }
}
