package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReportGenerator(
    reportGeneratorName: Option[String] = None,
    reportType: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ReportType]
    ] = None,
    reportContext: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportContext
    ] = None,
    reportFrequency: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency
    ] = None,
    licenseManagerReportGeneratorArn: Option[String] = None,
    lastRunStatus: Option[String] = None,
    lastRunFailureReason: Option[String] = None,
    lastReportGenerationTime: Option[String] = None,
    reportCreatorAccount: Option[String] = None,
    description: Option[String] = None,
    s3Location: Option[io.github.vigoo.zioaws.licensemanager.model.S3Location] =
      None,
    createTime: Option[String] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.licensemanager.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ReportGenerator = {
    import ReportGenerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportGenerator
      .builder()
      .optionallyWith(
        reportGeneratorName.map(value => value: java.lang.String)
      )(_.reportGeneratorName)
      .optionallyWith(
        reportType.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reportTypeWithStrings)
      .optionallyWith(reportContext.map(value => value.buildAwsValue()))(
        _.reportContext
      )
      .optionallyWith(reportFrequency.map(value => value.buildAwsValue()))(
        _.reportFrequency
      )
      .optionallyWith(
        licenseManagerReportGeneratorArn.map(value => value: java.lang.String)
      )(_.licenseManagerReportGeneratorArn)
      .optionallyWith(lastRunStatus.map(value => value: java.lang.String))(
        _.lastRunStatus
      )
      .optionallyWith(
        lastRunFailureReason.map(value => value: java.lang.String)
      )(_.lastRunFailureReason)
      .optionallyWith(
        lastReportGenerationTime.map(value => value: java.lang.String)
      )(_.lastReportGenerationTime)
      .optionallyWith(
        reportCreatorAccount.map(value => value: java.lang.String)
      )(_.reportCreatorAccount)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .optionallyWith(createTime.map(value => value: java.lang.String))(
        _.createTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ReportGenerator
      .wrap(buildAwsValue())
}
object ReportGenerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ReportGenerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.ReportGenerator =
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator(
        reportGeneratorNameValue.map(value => value),
        reportTypeValue.map(value => value),
        reportContextValue.map(value => value.editable),
        reportFrequencyValue.map(value => value.editable),
        licenseManagerReportGeneratorArnValue.map(value => value),
        lastRunStatusValue.map(value => value),
        lastRunFailureReasonValue.map(value => value),
        lastReportGenerationTimeValue.map(value => value),
        reportCreatorAccountValue.map(value => value),
        descriptionValue.map(value => value),
        s3LocationValue.map(value => value.editable),
        createTimeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def reportGeneratorNameValue: Option[String]
    def reportTypeValue
        : Option[List[io.github.vigoo.zioaws.licensemanager.model.ReportType]]
    def reportContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly
    ]
    def reportFrequencyValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly
    ]
    def licenseManagerReportGeneratorArnValue: Option[String]
    def lastRunStatusValue: Option[String]
    def lastRunFailureReasonValue: Option[String]
    def lastReportGenerationTimeValue: Option[String]
    def reportCreatorAccountValue: Option[String]
    def descriptionValue: Option[String]
    def s3LocationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly
    ]
    def createTimeValue: Option[String]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]]
    def reportGeneratorName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reportGeneratorName", reportGeneratorNameValue)
    def reportType: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ReportType
    ]] = AwsError.unwrapOptionField("reportType", reportTypeValue)
    def reportContext: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly
    ] = AwsError.unwrapOptionField("reportContext", reportContextValue)
    def reportFrequency: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly
    ] = AwsError.unwrapOptionField("reportFrequency", reportFrequencyValue)
    def licenseManagerReportGeneratorArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseManagerReportGeneratorArn",
        licenseManagerReportGeneratorArnValue
      )
    def lastRunStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastRunStatus", lastRunStatusValue)
    def lastRunFailureReason: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lastRunFailureReason", lastRunFailureReasonValue)
    def lastReportGenerationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "lastReportGenerationTime",
        lastReportGenerationTimeValue
      )
    def reportCreatorAccount: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reportCreatorAccount", reportCreatorAccountValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def s3Location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("s3Location", s3LocationValue)
    def createTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createTime", createTimeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportGenerator
  ) extends io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly {
    override def reportGeneratorNameValue: Option[String] =
      scala.Option(impl.reportGeneratorName()).map(value => value: String)
    override def reportTypeValue
        : Option[List[io.github.vigoo.zioaws.licensemanager.model.ReportType]] =
      scala
        .Option(impl.reportType())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.licensemanager.model.ReportType.wrap(item)
          }.toList
        )
    override def reportContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly
    ] = scala
      .Option(impl.reportContext())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ReportContext.wrap(value)
      )
    override def reportFrequencyValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly
    ] = scala
      .Option(impl.reportFrequency())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.wrap(value)
      )
    override def licenseManagerReportGeneratorArnValue: Option[String] = scala
      .Option(impl.licenseManagerReportGeneratorArn())
      .map(value => value: String)
    override def lastRunStatusValue: Option[String] =
      scala.Option(impl.lastRunStatus()).map(value => value: String)
    override def lastRunFailureReasonValue: Option[String] =
      scala.Option(impl.lastRunFailureReason()).map(value => value: String)
    override def lastReportGenerationTimeValue: Option[String] =
      scala.Option(impl.lastReportGenerationTime()).map(value => value: String)
    override def reportCreatorAccountValue: Option[String] =
      scala.Option(impl.reportCreatorAccount()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def s3LocationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.S3Location.ReadOnly
    ] = scala
      .Option(impl.s3Location())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.S3Location.wrap(value)
      )
    override def createTimeValue: Option[String] =
      scala.Option(impl.createTime()).map(value => value: String)
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportGenerator
  ): io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly =
    new Wrapper(impl)
}
