package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProductInformationFilter(
    productInformationFilterName: String,
    productInformationFilterValue: Option[Iterable[String]] = None,
    productInformationFilterComparator: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter = {
    import ProductInformationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter
      .builder()
      .productInformationFilterName(
        productInformationFilterName: java.lang.String
      )
      .optionallyWith(
        productInformationFilterValue.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productInformationFilterValue)
      .productInformationFilterComparator(
        productInformationFilterComparator: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter
      .wrap(buildAwsValue())
}
object ProductInformationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter =
      io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter(
        productInformationFilterNameValue,
        productInformationFilterValueValue.map(value => value),
        productInformationFilterComparatorValue
      )
    def productInformationFilterNameValue: String
    def productInformationFilterValueValue: Option[List[String]]
    def productInformationFilterComparatorValue: String
    def productInformationFilterName: ZIO[Any, Nothing, String] =
      ZIO.succeed(productInformationFilterNameValue)
    def productInformationFilterValue: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "productInformationFilterValue",
        productInformationFilterValueValue
      )
    def productInformationFilterComparator: ZIO[Any, Nothing, String] =
      ZIO.succeed(productInformationFilterComparatorValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter
  ) extends io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly {
    override def productInformationFilterNameValue: String =
      impl.productInformationFilterName(): String
    override def productInformationFilterValueValue: Option[List[String]] =
      scala
        .Option(impl.productInformationFilterValue())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override def productInformationFilterComparatorValue: String =
      impl.productInformationFilterComparator(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter
  ): io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly =
    new Wrapper(impl)
}
