package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxInteger
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListUsageForLicenseConfigurationRequest(
    licenseConfigurationArn: String,
    maxResults: Option[BoxInteger] = None,
    nextToken: Option[String] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Filter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest = {
    import ListUsageForLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest
      .builder()
      .licenseConfigurationArn(licenseConfigurationArn: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object ListUsageForLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .ListUsageForLicenseConfigurationRequest(
          licenseConfigurationArnValue,
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value),
          filtersValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def licenseConfigurationArnValue: String
    def maxResultsValue: Option[BoxInteger]
    def nextTokenValue: Option[String]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConfigurationArnValue)
    def maxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationRequest.ReadOnly {
    override def licenseConfigurationArnValue: String =
      impl.licenseConfigurationArn(): String
    override def maxResultsValue: Option[BoxInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxInteger)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
