package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.MaxSize100
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTokensRequest(
    tokenIds: Option[Iterable[String]] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Filter]
    ] = None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxSize100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListTokensRequest = {
    import ListTokensRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTokensRequest
      .builder()
      .optionallyWith(
        tokenIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tokenIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest
      .wrap(buildAwsValue())
}
object ListTokensRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListTokensRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest =
      io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest(
        tokenIdsValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def tokenIdsValue: Option[List[String]]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def maxResultsValue: Option[MaxSize100]
    def tokenIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tokenIds", tokenIdsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListTokensRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest.ReadOnly {
    override def tokenIdsValue: Option[List[String]] = scala
      .Option(impl.tokenIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Filter.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: Option[MaxSize100] =
      scala.Option(impl.maxResults()).map(value => value: MaxSize100)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListTokensRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListTokensRequest.ReadOnly =
    new Wrapper(impl)
}
