package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResourceInventoryResponse(
    resourceInventoryList: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ResourceInventory]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse = {
    import ListResourceInventoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse
      .builder()
      .optionallyWith(
        resourceInventoryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceInventoryList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse
      .wrap(buildAwsValue())
}
object ListResourceInventoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse =
      io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse(
        resourceInventoryListValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def resourceInventoryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def resourceInventoryList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceInventoryList",
      resourceInventoryListValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse.ReadOnly {
    override def resourceInventoryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
    ]] = scala
      .Option(impl.resourceInventoryList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceInventory
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryResponse.ReadOnly =
    new Wrapper(impl)
}
