package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicensesResponse(
    licenses: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.License]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse = {
    import ListLicensesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse
      .builder()
      .optionallyWith(
        licenses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse
      .wrap(buildAwsValue())
}
object ListLicensesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse =
      io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse(
        licensesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def licensesValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def licenses: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
    ]] = AwsError.unwrapOptionField("licenses", licensesValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse.ReadOnly {
    override def licensesValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly]
    ] = scala
      .Option(impl.licenses())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.License.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicensesResponse.ReadOnly =
    new Wrapper(impl)
}
