package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseSpecificationsForResourceResponse(
    licenseSpecifications: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse = {
    import ListLicenseSpecificationsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse
      .builder()
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceResponse
      .wrap(buildAwsValue())
}
object ListLicenseSpecificationsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseSpecificationsForResourceResponse(
          licenseSpecificationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseSpecifications: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseSpecifications",
      licenseSpecificationsValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceResponse.ReadOnly {
    override def licenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
