package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxInteger
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseSpecificationsForResourceRequest(
    resourceArn: String,
    maxResults: Option[BoxInteger] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest = {
    import ListLicenseSpecificationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceRequest
      .wrap(buildAwsValue())
}
object ListLicenseSpecificationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseSpecificationsForResourceRequest(
          resourceArnValue,
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def resourceArnValue: String
    def maxResultsValue: Option[BoxInteger]
    def nextTokenValue: Option[String]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def maxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def maxResultsValue: Option[BoxInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxInteger)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseSpecificationsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
