package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseConversionTasksResponse(
    licenseConversionTasks: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask
    ]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse = {
    import ListLicenseConversionTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse
      .builder()
      .optionallyWith(
        licenseConversionTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseConversionTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksResponse
      .wrap(buildAwsValue())
}
object ListLicenseConversionTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseConversionTasksResponse(
          licenseConversionTasksValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseConversionTasksValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseConversionTasks: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseConversionTasks",
      licenseConversionTasksValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksResponse.ReadOnly {
    override def licenseConversionTasksValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
    ]] = scala
      .Option(impl.licenseConversionTasks())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseConversionTasksResponse.ReadOnly =
    new Wrapper(impl)
}
