package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseConfigurationsResponse(
    licenseConfigurations: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse = {
    import ListLicenseConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse
      .builder()
      .optionallyWith(
        licenseConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseConfigurations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConfigurationsResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListLicenseConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseConfigurationsResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListLicenseConfigurationsResponse(
          licenseConfigurationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseConfigurations",
      licenseConfigurationsValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseConfigurationsResponse.ReadOnly {
    override def licenseConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
    ]] = scala
      .Option(impl.licenseConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
