package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDistributedGrantsResponse(
    grants: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Grant]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse = {
    import ListDistributedGrantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse
      .wrap(buildAwsValue())
}
object ListDistributedGrantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse =
      io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse(
        grantsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def grantsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def grants: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grantsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse.ReadOnly {
    override def grantsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly]
    ] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Grant.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListDistributedGrantsResponse.ReadOnly =
    new Wrapper(impl)
}
