package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAssociationsForLicenseConfigurationResponse(
    licenseConfigurationAssociations: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation
    ]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse = {
    import ListAssociationsForLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
      .builder()
      .optionallyWith(
        licenseConfigurationAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseConfigurationAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListAssociationsForLicenseConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
      .wrap(buildAwsValue())
}
object ListAssociationsForLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListAssociationsForLicenseConfigurationResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListAssociationsForLicenseConfigurationResponse(
          licenseConfigurationAssociationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseConfigurationAssociationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseConfigurationAssociations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseConfigurationAssociations",
      licenseConfigurationAssociationsValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListAssociationsForLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationAssociationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
    ]] = scala
      .Option(impl.licenseConfigurationAssociations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListAssociationsForLicenseConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
