package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.DateTime
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseOperationFailure(
    resourceArn: Option[String] = None,
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    errorMessage: Option[String] = None,
    failureTime: Option[DateTime] = None,
    operationName: Option[String] = None,
    resourceOwnerId: Option[String] = None,
    operationRequestedBy: Option[String] = None,
    metadataList: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure = {
    import LicenseOperationFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(failureTime.map(value => value: Instant))(_.failureTime)
      .optionallyWith(operationName.map(value => value: java.lang.String))(
        _.operationName
      )
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(
        operationRequestedBy.map(value => value: java.lang.String)
      )(_.operationRequestedBy)
      .optionallyWith(
        metadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metadataList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure
      .wrap(buildAwsValue())
}
object LicenseOperationFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure =
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure(
        resourceArnValue.map(value => value),
        resourceTypeValue.map(value => value),
        errorMessageValue.map(value => value),
        failureTimeValue.map(value => value),
        operationNameValue.map(value => value),
        resourceOwnerIdValue.map(value => value),
        operationRequestedByValue.map(value => value),
        metadataListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def resourceArnValue: Option[String]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def errorMessageValue: Option[String]
    def failureTimeValue: Option[DateTime]
    def operationNameValue: Option[String]
    def resourceOwnerIdValue: Option[String]
    def operationRequestedByValue: Option[String]
    def metadataListValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def errorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessageValue)
    def failureTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("failureTime", failureTimeValue)
    def operationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationName", operationNameValue)
    def resourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def operationRequestedBy: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("operationRequestedBy", operationRequestedByValue)
    def metadataList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("metadataList", metadataListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly {
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def errorMessageValue: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override def failureTimeValue: Option[DateTime] =
      scala.Option(impl.failureTime()).map(value => value: DateTime)
    override def operationNameValue: Option[String] =
      scala.Option(impl.operationName()).map(value => value: String)
    override def resourceOwnerIdValue: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def operationRequestedByValue: Option[String] =
      scala.Option(impl.operationRequestedBy()).map(value => value: String)
    override def metadataListValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.metadataList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly =
    new Wrapper(impl)
}
