package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseCountingType {
  def unwrap
      : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType
}
object LicenseCountingType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.LicenseCountingType
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.V_CPU =>
        val r = vCPU
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.INSTANCE =>
        val r = Instance
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.CORE =>
        val r = Core
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.SOCKET =>
        val r = Socket
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType =
      software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.UNKNOWN_TO_SDK_VERSION
  }
  case object vCPU
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType =
      software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.V_CPU
  }
  case object Instance
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType =
      software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.INSTANCE
  }
  case object Core
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType =
      software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.CORE
  }
  case object Socket
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseCountingType =
      software.amazon.awssdk.services.licensemanager.model.LicenseCountingType.SOCKET
  }
}
