package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  DateTime,
  LicenseConversionTaskId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseConversionTask(
    licenseConversionTaskId: Option[LicenseConversionTaskId] = None,
    resourceArn: Option[String] = None,
    sourceLicenseContext: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
    ] = None,
    destinationLicenseContext: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
    ] = None,
    status: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = None,
    statusMessage: Option[String] = None,
    startTime: Option[DateTime] = None,
    licenseConversionTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask = {
    import LicenseConversionTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask
      .builder()
      .optionallyWith(
        licenseConversionTaskId.map(value => value: java.lang.String)
      )(_.licenseConversionTaskId)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(sourceLicenseContext.map(value => value.buildAwsValue()))(
        _.sourceLicenseContext
      )
      .optionallyWith(
        destinationLicenseContext.map(value => value.buildAwsValue())
      )(_.destinationLicenseContext)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(licenseConversionTime.map(value => value: Instant))(
        _.licenseConversionTime
      )
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask
      .wrap(buildAwsValue())
}
object LicenseConversionTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask =
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask(
        licenseConversionTaskIdValue.map(value => value),
        resourceArnValue.map(value => value),
        sourceLicenseContextValue.map(value => value.editable),
        destinationLicenseContextValue.map(value => value.editable),
        statusValue.map(value => value),
        statusMessageValue.map(value => value),
        startTimeValue.map(value => value),
        licenseConversionTimeValue.map(value => value),
        endTimeValue.map(value => value)
      )
    def licenseConversionTaskIdValue: Option[LicenseConversionTaskId]
    def resourceArnValue: Option[String]
    def sourceLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ]
    def destinationLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ]
    def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ]
    def statusMessageValue: Option[String]
    def startTimeValue: Option[DateTime]
    def licenseConversionTimeValue: Option[DateTime]
    def endTimeValue: Option[DateTime]
    def licenseConversionTaskId: ZIO[Any, AwsError, LicenseConversionTaskId] =
      AwsError.unwrapOptionField(
        "licenseConversionTaskId",
        licenseConversionTaskIdValue
      )
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def sourceLicenseContext: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceLicenseContext",
      sourceLicenseContextValue
    )
    def destinationLicenseContext: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationLicenseContext",
      destinationLicenseContextValue
    )
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def statusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessageValue)
    def startTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTimeValue)
    def licenseConversionTime: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("licenseConversionTime", licenseConversionTimeValue)
    def endTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly {
    override def licenseConversionTaskIdValue: Option[LicenseConversionTaskId] =
      scala
        .Option(impl.licenseConversionTaskId())
        .map(value => value: LicenseConversionTaskId)
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def sourceLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = scala
      .Option(impl.sourceLicenseContext())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
          .wrap(value)
      )
    override def destinationLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = scala
      .Option(impl.destinationLicenseContext())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
          .wrap(value)
      )
    override def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
          .wrap(value)
      )
    override def statusMessageValue: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override def startTimeValue: Option[DateTime] =
      scala.Option(impl.startTime()).map(value => value: DateTime)
    override def licenseConversionTimeValue: Option[DateTime] =
      scala.Option(impl.licenseConversionTime()).map(value => value: DateTime)
    override def endTimeValue: Option[DateTime] =
      scala.Option(impl.endTime()).map(value => value: DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly =
    new Wrapper(impl)
}
