package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  DateTime,
  LicenseConversionTaskId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseConversionTaskResponse(
    licenseConversionTaskId: Option[LicenseConversionTaskId] = None,
    resourceArn: Option[String] = None,
    sourceLicenseContext: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
    ] = None,
    destinationLicenseContext: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
    ] = None,
    statusMessage: Option[String] = None,
    status: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = None,
    startTime: Option[DateTime] = None,
    licenseConversionTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse = {
    import GetLicenseConversionTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse
      .builder()
      .optionallyWith(
        licenseConversionTaskId.map(value => value: java.lang.String)
      )(_.licenseConversionTaskId)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(sourceLicenseContext.map(value => value.buildAwsValue()))(
        _.sourceLicenseContext
      )
      .optionallyWith(
        destinationLicenseContext.map(value => value.buildAwsValue())
      )(_.destinationLicenseContext)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(licenseConversionTime.map(value => value: Instant))(
        _.licenseConversionTime
      )
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse
      .wrap(buildAwsValue())
}
object GetLicenseConversionTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseConversionTaskResponse(
          licenseConversionTaskIdValue.map(value => value),
          resourceArnValue.map(value => value),
          sourceLicenseContextValue.map(value => value.editable),
          destinationLicenseContextValue.map(value => value.editable),
          statusMessageValue.map(value => value),
          statusValue.map(value => value),
          startTimeValue.map(value => value),
          licenseConversionTimeValue.map(value => value),
          endTimeValue.map(value => value)
        )
    def licenseConversionTaskIdValue: Option[LicenseConversionTaskId]
    def resourceArnValue: Option[String]
    def sourceLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ]
    def destinationLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ]
    def statusMessageValue: Option[String]
    def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ]
    def startTimeValue: Option[DateTime]
    def licenseConversionTimeValue: Option[DateTime]
    def endTimeValue: Option[DateTime]
    def licenseConversionTaskId: ZIO[Any, AwsError, LicenseConversionTaskId] =
      AwsError.unwrapOptionField(
        "licenseConversionTaskId",
        licenseConversionTaskIdValue
      )
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def sourceLicenseContext: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceLicenseContext",
      sourceLicenseContextValue
    )
    def destinationLicenseContext: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationLicenseContext",
      destinationLicenseContextValue
    )
    def statusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessageValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def startTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTimeValue)
    def licenseConversionTime: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("licenseConversionTime", licenseConversionTimeValue)
    def endTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly {
    override def licenseConversionTaskIdValue: Option[LicenseConversionTaskId] =
      scala
        .Option(impl.licenseConversionTaskId())
        .map(value => value: LicenseConversionTaskId)
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def sourceLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = scala
      .Option(impl.sourceLicenseContext())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
          .wrap(value)
      )
    override def destinationLicenseContextValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = scala
      .Option(impl.destinationLicenseContext())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
          .wrap(value)
      )
    override def statusMessageValue: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus
          .wrap(value)
      )
    override def startTimeValue: Option[DateTime] =
      scala.Option(impl.startTime()).map(value => value: DateTime)
    override def licenseConversionTimeValue: Option[DateTime] =
      scala.Option(impl.licenseConversionTime()).map(value => value: DateTime)
    override def endTimeValue: Option[DateTime] =
      scala.Option(impl.endTime()).map(value => value: DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly =
    new Wrapper(impl)
}
