package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  BoxBoolean,
  BoxLong
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseConfigurationResponse(
    licenseConfigurationId: Option[String] = None,
    licenseConfigurationArn: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    licenseCountingType: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    ] = None,
    licenseRules: Option[Iterable[String]] = None,
    licenseCount: Option[BoxLong] = None,
    licenseCountHardLimit: Option[BoxBoolean] = None,
    consumedLicenses: Option[BoxLong] = None,
    status: Option[String] = None,
    ownerAccountId: Option[String] = None,
    consumedLicenseSummaryList: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary
    ]] = None,
    managedResourceSummaryList: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary
    ]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.licensemanager.model.Tag]] =
      None,
    productInformationList: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ProductInformation]
    ] = None,
    automatedDiscoveryInformation: Option[
      io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation
    ] = None,
    disassociateWhenNotFound: Option[BoxBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse = {
    import GetLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse
      .builder()
      .optionallyWith(
        licenseConfigurationId.map(value => value: java.lang.String)
      )(_.licenseConfigurationId)
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(licenseCountingType.map(value => value.unwrap))(
        _.licenseCountingType
      )
      .optionallyWith(
        licenseRules.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.licenseRules)
      .optionallyWith(licenseCount.map(value => value: java.lang.Long))(
        _.licenseCount
      )
      .optionallyWith(
        licenseCountHardLimit.map(value => value: java.lang.Boolean)
      )(_.licenseCountHardLimit)
      .optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(
        _.consumedLicenses
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(ownerAccountId.map(value => value: java.lang.String))(
        _.ownerAccountId
      )
      .optionallyWith(
        consumedLicenseSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedLicenseSummaryList)
      .optionallyWith(
        managedResourceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedResourceSummaryList)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        productInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productInformationList)
      .optionallyWith(
        automatedDiscoveryInformation.map(value => value.buildAwsValue())
      )(_.automatedDiscoveryInformation)
      .optionallyWith(
        disassociateWhenNotFound.map(value => value: java.lang.Boolean)
      )(_.disassociateWhenNotFound)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse
      .wrap(buildAwsValue())
}
object GetLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseConfigurationResponse(
          licenseConfigurationIdValue.map(value => value),
          licenseConfigurationArnValue.map(value => value),
          nameValue.map(value => value),
          descriptionValue.map(value => value),
          licenseCountingTypeValue.map(value => value),
          licenseRulesValue.map(value => value),
          licenseCountValue.map(value => value),
          licenseCountHardLimitValue.map(value => value),
          consumedLicensesValue.map(value => value),
          statusValue.map(value => value),
          ownerAccountIdValue.map(value => value),
          consumedLicenseSummaryListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          managedResourceSummaryListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          productInformationListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          automatedDiscoveryInformationValue.map(value => value.editable),
          disassociateWhenNotFoundValue.map(value => value)
        )
    def licenseConfigurationIdValue: Option[String]
    def licenseConfigurationArnValue: Option[String]
    def nameValue: Option[String]
    def descriptionValue: Option[String]
    def licenseCountingTypeValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    ]
    def licenseRulesValue: Option[List[String]]
    def licenseCountValue: Option[BoxLong]
    def licenseCountHardLimitValue: Option[BoxBoolean]
    def consumedLicensesValue: Option[BoxLong]
    def statusValue: Option[String]
    def ownerAccountIdValue: Option[String]
    def consumedLicenseSummaryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly
    ]]
    def managedResourceSummaryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly
    ]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]]
    def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]]
    def automatedDiscoveryInformationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly
    ]
    def disassociateWhenNotFoundValue: Option[BoxBoolean]
    def licenseConfigurationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("licenseConfigurationId", licenseConfigurationIdValue)
    def licenseConfigurationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseConfigurationArn",
        licenseConfigurationArnValue
      )
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def licenseCountingType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    ] = AwsError.unwrapOptionField(
      "licenseCountingType",
      licenseCountingTypeValue
    )
    def licenseRules: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def licenseCount: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, AwsError, BoxBoolean] = AwsError
      .unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def consumedLicenses: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def ownerAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountIdValue)
    def consumedLicenseSummaryList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "consumedLicenseSummaryList",
      consumedLicenseSummaryListValue
    )
    def managedResourceSummaryList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "managedResourceSummaryList",
      managedResourceSummaryListValue
    )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def productInformationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "productInformationList",
      productInformationListValue
    )
    def automatedDiscoveryInformation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "automatedDiscoveryInformation",
      automatedDiscoveryInformationValue
    )
    def disassociateWhenNotFound: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField(
        "disassociateWhenNotFound",
        disassociateWhenNotFoundValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationIdValue: Option[String] =
      scala.Option(impl.licenseConfigurationId()).map(value => value: String)
    override def licenseConfigurationArnValue: Option[String] =
      scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def licenseCountingTypeValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    ] = scala
      .Option(impl.licenseCountingType())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
          .wrap(value)
      )
    override def licenseRulesValue: Option[List[String]] = scala
      .Option(impl.licenseRules())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def licenseCountValue: Option[BoxLong] =
      scala.Option(impl.licenseCount()).map(value => value: BoxLong)
    override def licenseCountHardLimitValue: Option[BoxBoolean] =
      scala.Option(impl.licenseCountHardLimit()).map(value => value: BoxBoolean)
    override def consumedLicensesValue: Option[BoxLong] =
      scala.Option(impl.consumedLicenses()).map(value => value: BoxLong)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def ownerAccountIdValue: Option[String] =
      scala.Option(impl.ownerAccountId()).map(value => value: String)
    override def consumedLicenseSummaryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly
    ]] = scala
      .Option(impl.consumedLicenseSummaryList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary
            .wrap(item)
        }.toList
      )
    override def managedResourceSummaryListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary.ReadOnly
    ]] = scala
      .Option(impl.managedResourceSummaryList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ManagedResourceSummary
            .wrap(item)
        }.toList
      )
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Tag.wrap(item)
        }.toList
      )
    override def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = scala
      .Option(impl.productInformationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ProductInformation
            .wrap(item)
        }.toList
      )
    override def automatedDiscoveryInformationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly
    ] = scala
      .Option(impl.automatedDiscoveryInformation())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation
          .wrap(value)
      )
    override def disassociateWhenNotFoundValue: Option[BoxBoolean] = scala
      .Option(impl.disassociateWhenNotFound())
      .map(value => value: BoxBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
