package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.TokenString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccessTokenRequest(
    token: TokenString,
    tokenProperties: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest = {
    import GetAccessTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest
      .builder()
      .token(token: java.lang.String)
      .optionallyWith(
        tokenProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tokenProperties)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest
      .wrap(buildAwsValue())
}
object GetAccessTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest =
      io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest(
        tokenValue,
        tokenPropertiesValue.map(value => value)
      )
    def tokenValue: TokenString
    def tokenPropertiesValue: Option[List[String]]
    def token: ZIO[Any, Nothing, TokenString] = ZIO.succeed(tokenValue)
    def tokenProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest.ReadOnly {
    override def tokenValue: TokenString = impl.token(): TokenString
    override def tokenPropertiesValue: Option[List[String]] = scala
      .Option(impl.tokenProperties())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest
  ): io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenRequest.ReadOnly =
    new Wrapper(impl)
}
