package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  FilterValue,
  FilterName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Filter(
    name: Option[FilterName] = None,
    values: Option[Iterable[FilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Filter
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Filter =
      io.github.vigoo.zioaws.licensemanager.model
        .Filter(nameValue.map(value => value), valuesValue.map(value => value))
    def nameValue: Option[FilterName]
    def valuesValue: Option[List[FilterValue]]
    def name: ZIO[Any, AwsError, FilterName] =
      AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Filter
  ) extends io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly {
    override def nameValue: Option[FilterName] =
      scala.Option(impl.name()).map(value => value: FilterName)
    override def valuesValue: Option[List[FilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: FilterValue
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Filter
  ): io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly = new Wrapper(
    impl
  )
}
