package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait EntitlementDataUnit {
  def unwrap
      : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit
}
object EntitlementDataUnit {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit
  ): io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.COUNT =>
        val r = Count
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.NONE =>
        val r = None
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.SECONDS =>
        val r = Seconds
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MICROSECONDS =>
        val r = Microseconds
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MILLISECONDS =>
        val r = Milliseconds
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BYTES =>
        val r = Bytes
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBYTES =>
        val r = Kilobytes
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABYTES =>
        val r = Megabytes
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABYTES =>
        val r = Gigabytes
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABYTES =>
        val r = Terabytes
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BITS =>
        val r = Bits
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBITS =>
        val r = Kilobits
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABITS =>
        val r = Megabits
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABITS =>
        val r = Gigabits
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABITS =>
        val r = Terabits
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.PERCENT =>
        val r = Percent
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BYTES_SECOND =>
        val r = `Bytes/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBYTES_SECOND =>
        val r = `Kilobytes/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABYTES_SECOND =>
        val r = `Megabytes/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABYTES_SECOND =>
        val r = `Gigabytes/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABYTES_SECOND =>
        val r = `Terabytes/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BITS_SECOND =>
        val r = `Bits/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBITS_SECOND =>
        val r = `Kilobits/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABITS_SECOND =>
        val r = `Megabits/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABITS_SECOND =>
        val r = `Gigabits/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABITS_SECOND =>
        val r = `Terabits/Second`
        r
      case software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.COUNT_SECOND =>
        val r = `Count/Second`
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Count
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.COUNT
  }
  case object None
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.NONE
  }
  case object Seconds
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.SECONDS
  }
  case object Microseconds
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MICROSECONDS
  }
  case object Milliseconds
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MILLISECONDS
  }
  case object Bytes
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BYTES
  }
  case object Kilobytes
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBYTES
  }
  case object Megabytes
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABYTES
  }
  case object Gigabytes
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABYTES
  }
  case object Terabytes
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABYTES
  }
  case object Bits
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BITS
  }
  case object Kilobits
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBITS
  }
  case object Megabits
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABITS
  }
  case object Gigabits
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABITS
  }
  case object Terabits
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABITS
  }
  case object Percent
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.PERCENT
  }
  case object `Bytes/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BYTES_SECOND
  }
  case object `Kilobytes/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBYTES_SECOND
  }
  case object `Megabytes/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABYTES_SECOND
  }
  case object `Gigabytes/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABYTES_SECOND
  }
  case object `Terabytes/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABYTES_SECOND
  }
  case object `Bits/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.BITS_SECOND
  }
  case object `Kilobits/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.KILOBITS_SECOND
  }
  case object `Megabits/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.MEGABITS_SECOND
  }
  case object `Gigabits/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.GIGABITS_SECOND
  }
  case object `Terabits/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.TERABITS_SECOND
  }
  case object `Count/Second`
      extends io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit =
      software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit.COUNT_SECOND
  }
}
