package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EntitlementData(
    name: String,
    value: Option[String] = None,
    unit: io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.EntitlementData = {
    import EntitlementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.EntitlementData
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .unit(unit.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.EntitlementData
      .wrap(buildAwsValue())
}
object EntitlementData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.EntitlementData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.EntitlementData =
      io.github.vigoo.zioaws.licensemanager.model
        .EntitlementData(nameValue, valueValue.map(value => value), unitValue)
    def nameValue: String
    def valueValue: Option[String]
    def unitValue
        : io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
    def unit: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
    ] = ZIO.succeed(unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.EntitlementData
  ) extends io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override def unitValue
        : io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit =
      io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
        .wrap(impl.unit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.EntitlementData
  ): io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly =
    new Wrapper(impl)
}
