package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLicenseRequest(licenseArn: Arn, sourceVersion: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest = {
    import DeleteLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .sourceVersion(sourceVersion: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseRequest
      .wrap(buildAwsValue())
}
object DeleteLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .DeleteLicenseRequest(licenseArnValue, sourceVersionValue)
    def licenseArnValue: Arn
    def sourceVersionValue: String
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def sourceVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceVersionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def sourceVersionValue: String = impl.sourceVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
