package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLicenseManagerReportGeneratorRequest(
    licenseManagerReportGeneratorArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest = {
    import DeleteLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
      .builder()
      .licenseManagerReportGeneratorArn(
        licenseManagerReportGeneratorArn: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
      .wrap(buildAwsValue())
}
object DeleteLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .DeleteLicenseManagerReportGeneratorRequest(
          licenseManagerReportGeneratorArnValue
        )
    def licenseManagerReportGeneratorArnValue: String
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseManagerReportGeneratorArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest.ReadOnly {
    override def licenseManagerReportGeneratorArnValue: String =
      impl.licenseManagerReportGeneratorArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest.ReadOnly =
    new Wrapper(impl)
}
