package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLicenseConfigurationRequest(
    licenseConfigurationArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest = {
    import DeleteLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest
      .builder()
      .licenseConfigurationArn(licenseConfigurationArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .DeleteLicenseConfigurationRequest(licenseConfigurationArnValue)
    def licenseConfigurationArnValue: String
    def licenseConfigurationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConfigurationArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationRequest.ReadOnly {
    override def licenseConfigurationArnValue: String =
      impl.licenseConfigurationArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
