package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseVersionResponse(
    licenseArn: Option[Arn] = None,
    version: Option[String] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse = {
    import CreateLicenseVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse
      .builder()
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse
      .wrap(buildAwsValue())
}
object CreateLicenseVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse =
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse(
        licenseArnValue.map(value => value),
        versionValue.map(value => value),
        statusValue.map(value => value)
      )
    def licenseArnValue: Option[Arn]
    def versionValue: Option[String]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus]
    def licenseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly {
    override def licenseArnValue: Option[Arn] =
      scala.Option(impl.licenseArn()).map(value => value: Arn)
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly =
    new Wrapper(impl)
}
