package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseResponse(
    licenseArn: Option[Arn] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse = {
    import CreateLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse
      .builder()
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse
      .wrap(buildAwsValue())
}
object CreateLicenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse =
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse(
        licenseArnValue.map(value => value),
        statusValue.map(value => value),
        versionValue.map(value => value)
      )
    def licenseArnValue: Option[Arn]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus]
    def versionValue: Option[String]
    def licenseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly {
    override def licenseArnValue: Option[Arn] =
      scala.Option(impl.licenseArn()).map(value => value: Arn)
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseStatus.wrap(value)
        )
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly =
    new Wrapper(impl)
}
