package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.ClientToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseRequest(
    licenseName: String,
    productName: String,
    productSKU: String,
    issuer: io.github.vigoo.zioaws.licensemanager.model.Issuer,
    homeRegion: String,
    validity: io.github.vigoo.zioaws.licensemanager.model.DatetimeRange,
    entitlements: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement
    ],
    beneficiary: String,
    consumptionConfiguration: io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration,
    licenseMetadata: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest = {
    import CreateLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest
      .builder()
      .licenseName(licenseName: java.lang.String)
      .productName(productName: java.lang.String)
      .productSKU(productSKU: java.lang.String)
      .issuer(issuer.buildAwsValue())
      .homeRegion(homeRegion: java.lang.String)
      .validity(validity.buildAwsValue())
      .entitlements(entitlements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .beneficiary(beneficiary: java.lang.String)
      .consumptionConfiguration(consumptionConfiguration.buildAwsValue())
      .optionallyWith(
        licenseMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseMetadata)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest
      .wrap(buildAwsValue())
}
object CreateLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest(
        licenseNameValue,
        productNameValue,
        productSKUValue,
        issuerValue.editable,
        homeRegionValue,
        validityValue.editable,
        entitlementsValue.map { item =>
          item.editable
        },
        beneficiaryValue,
        consumptionConfigurationValue.editable,
        licenseMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        clientTokenValue
      )
    def licenseNameValue: String
    def productNameValue: String
    def productSKUValue: String
    def issuerValue: io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly
    def homeRegionValue: String
    def validityValue
        : io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    def entitlementsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly]
    def beneficiaryValue: String
    def consumptionConfigurationValue
        : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def clientTokenValue: ClientToken
    def licenseName: ZIO[Any, Nothing, String] = ZIO.succeed(licenseNameValue)
    def productName: ZIO[Any, Nothing, String] = ZIO.succeed(productNameValue)
    def productSKU: ZIO[Any, Nothing, String] = ZIO.succeed(productSKUValue)
    def issuer: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly
    ] = ZIO.succeed(issuerValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def validity: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    ] = ZIO.succeed(validityValue)
    def entitlements: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly
    ]] = ZIO.succeed(entitlementsValue)
    def beneficiary: ZIO[Any, Nothing, String] = ZIO.succeed(beneficiaryValue)
    def consumptionConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    ] = ZIO.succeed(consumptionConfigurationValue)
    def licenseMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest.ReadOnly {
    override def licenseNameValue: String = impl.licenseName(): String
    override def productNameValue: String = impl.productName(): String
    override def productSKUValue: String = impl.productSKU(): String
    override def issuerValue
        : io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.Issuer.wrap(impl.issuer())
    override def homeRegionValue: String = impl.homeRegion(): String
    override def validityValue
        : io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange
        .wrap(impl.validity())
    override def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly
    ] = impl
      .entitlements()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.Entitlement.wrap(item)
      }
      .toList
    override def beneficiaryValue: String = impl.beneficiary(): String
    override def consumptionConfigurationValue
        : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration
        .wrap(impl.consumptionConfiguration())
    override def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.licenseMetadata())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
