package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.LicenseConversionTaskId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseConversionTaskForResourceResponse(
    licenseConversionTaskId: Option[LicenseConversionTaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse = {
    import CreateLicenseConversionTaskForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
      .builder()
      .optionallyWith(
        licenseConversionTaskId.map(value => value: java.lang.String)
      )(_.licenseConversionTaskId)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
      .wrap(buildAwsValue())
}
object CreateLicenseConversionTaskForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .CreateLicenseConversionTaskForResourceResponse(
          licenseConversionTaskIdValue.map(value => value)
        )
    def licenseConversionTaskIdValue: Option[LicenseConversionTaskId]
    def licenseConversionTaskId: ZIO[Any, AwsError, LicenseConversionTaskId] =
      AwsError.unwrapOptionField(
        "licenseConversionTaskId",
        licenseConversionTaskIdValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly {
    override def licenseConversionTaskIdValue: Option[LicenseConversionTaskId] =
      scala
        .Option(impl.licenseConversionTaskId())
        .map(value => value: LicenseConversionTaskId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
