package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseConfigurationResponse(
    licenseConfigurationArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse = {
    import CreateLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .CreateLicenseConfigurationResponse(
          licenseConfigurationArnValue.map(value => value)
        )
    def licenseConfigurationArnValue: Option[String]
    def licenseConfigurationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseConfigurationArn",
        licenseConfigurationArnValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationArnValue: Option[String] =
      scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
