package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGrantVersionResponse(
    grantArn: Option[Arn] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse = {
    import CreateGrantVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse
      .builder()
      .optionallyWith(grantArn.map(value => value: java.lang.String))(
        _.grantArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse
      .wrap(buildAwsValue())
}
object CreateGrantVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse =
      io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse(
        grantArnValue.map(value => value),
        statusValue.map(value => value),
        versionValue.map(value => value)
      )
    def grantArnValue: Option[Arn]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus]
    def versionValue: Option[String]
    def grantArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("grantArn", grantArnValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GrantStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly {
    override def grantArnValue: Option[Arn] =
      scala.Option(impl.grantArn()).map(value => value: Arn)
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.GrantStatus.wrap(value)
        )
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly =
    new Wrapper(impl)
}
