package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{ClientToken, Arn}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CheckoutBorrowLicenseRequest(
    licenseArn: Arn,
    entitlements: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData
    ],
    digitalSignatureMethod: io.github.vigoo.zioaws.licensemanager.model.DigitalSignatureMethod,
    nodeId: Option[String] = None,
    checkoutMetadata: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest = {
    import CheckoutBorrowLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .entitlements(entitlements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .digitalSignatureMethod(digitalSignatureMethod.unwrap)
      .optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId)
      .optionallyWith(
        checkoutMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkoutMetadata)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest
      .wrap(buildAwsValue())
}
object CheckoutBorrowLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest(
        licenseArnValue,
        entitlementsValue.map { item =>
          item.editable
        },
        digitalSignatureMethodValue,
        nodeIdValue.map(value => value),
        checkoutMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        clientTokenValue
      )
    def licenseArnValue: Arn
    def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]
    def digitalSignatureMethodValue
        : io.github.vigoo.zioaws.licensemanager.model.DigitalSignatureMethod
    def nodeIdValue: Option[String]
    def checkoutMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def clientTokenValue: ClientToken
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def entitlements: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]] = ZIO.succeed(entitlementsValue)
    def digitalSignatureMethod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.DigitalSignatureMethod
    ] = ZIO.succeed(digitalSignatureMethodValue)
    def nodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def checkoutMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("checkoutMetadata", checkoutMetadataValue)
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ] = impl
      .entitlements()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.EntitlementData.wrap(item)
      }
      .toList
    override def digitalSignatureMethodValue
        : io.github.vigoo.zioaws.licensemanager.model.DigitalSignatureMethod =
      io.github.vigoo.zioaws.licensemanager.model.DigitalSignatureMethod
        .wrap(impl.digitalSignatureMethod())
    override def nodeIdValue: Option[String] =
      scala.Option(impl.nodeId()).map(value => value: String)
    override def checkoutMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.checkoutMetadata())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
