package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  BoxInteger,
  BoxBoolean
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BorrowConfiguration(
    allowEarlyCheckIn: BoxBoolean,
    maxTimeToLiveInMinutes: BoxInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration = {
    import BorrowConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration
      .builder()
      .allowEarlyCheckIn(allowEarlyCheckIn: java.lang.Boolean)
      .maxTimeToLiveInMinutes(maxTimeToLiveInMinutes: Integer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration
      .wrap(buildAwsValue())
}
object BorrowConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration =
      io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration(
        allowEarlyCheckInValue,
        maxTimeToLiveInMinutesValue
      )
    def allowEarlyCheckInValue: BoxBoolean
    def maxTimeToLiveInMinutesValue: BoxInteger
    def allowEarlyCheckIn: ZIO[Any, Nothing, BoxBoolean] =
      ZIO.succeed(allowEarlyCheckInValue)
    def maxTimeToLiveInMinutes: ZIO[Any, Nothing, BoxInteger] =
      ZIO.succeed(maxTimeToLiveInMinutesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration
  ) extends io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly {
    override def allowEarlyCheckInValue: BoxBoolean =
      impl.allowEarlyCheckIn(): BoxBoolean
    override def maxTimeToLiveInMinutesValue: BoxInteger =
      impl.maxTimeToLiveInMinutes(): BoxInteger
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration
  ): io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly =
    new Wrapper(impl)
}
