package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.UntagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.UntagResourceRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .UntagResourceRequest(resourceArnValue, tagKeysValue)
    def resourceArnValue: String
    def tagKeysValue: List[String]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.UntagResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def tagKeysValue: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest
  ): io.github.vigoo.zioaws.licensemanager.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
