package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceInventory(
    resourceId: Option[String] = None,
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    resourceArn: Option[String] = None,
    platform: Option[String] = None,
    platformVersion: Option[String] = None,
    resourceOwningAccountId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ResourceInventory = {
    import ResourceInventory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ResourceInventory
      .builder()
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        resourceOwningAccountId.map(value => value: java.lang.String)
      )(_.resourceOwningAccountId)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ResourceInventory
      .wrap(buildAwsValue())
}
object ResourceInventory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ResourceInventory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ResourceInventory =
      io.github.vigoo.zioaws.licensemanager.model.ResourceInventory(
        resourceIdValue.map(value => value),
        resourceTypeValue.map(value => value),
        resourceArnValue.map(value => value),
        platformValue.map(value => value),
        platformVersionValue.map(value => value),
        resourceOwningAccountIdValue.map(value => value)
      )
    def resourceIdValue: Option[String]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def resourceArnValue: Option[String]
    def platformValue: Option[String]
    def platformVersionValue: Option[String]
    def resourceOwningAccountIdValue: Option[String]
    def resourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceIdValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def platform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platformValue)
    def platformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersionValue)
    def resourceOwningAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "resourceOwningAccountId",
        resourceOwningAccountIdValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ResourceInventory
  ) extends io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly {
    override def resourceIdValue: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def platformValue: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override def platformVersionValue: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override def resourceOwningAccountIdValue: Option[String] =
      scala.Option(impl.resourceOwningAccountId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ResourceInventory
  ): io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly =
    new Wrapper(impl)
}
