package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReportContext(licenseConfigurationArns: Iterable[Arn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ReportContext = {
    import ReportContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportContext
      .builder()
      .licenseConfigurationArns(licenseConfigurationArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ReportContext
      .wrap(buildAwsValue())
}
object ReportContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ReportContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.ReportContext =
      io.github.vigoo.zioaws.licensemanager.model
        .ReportContext(licenseConfigurationArnsValue)
    def licenseConfigurationArnsValue: List[Arn]
    def licenseConfigurationArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(licenseConfigurationArnsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportContext
  ) extends io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly {
    override def licenseConfigurationArnsValue: List[Arn] = impl
      .licenseConfigurationArns()
      .asScala
      .map { item =>
        item: Arn
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportContext
  ): io.github.vigoo.zioaws.licensemanager.model.ReportContext.ReadOnly =
    new Wrapper(impl)
}
