package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait RenewType {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.RenewType
}
object RenewType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.RenewType
  ): io.github.vigoo.zioaws.licensemanager.model.RenewType = value match {
    case software.amazon.awssdk.services.licensemanager.model.RenewType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.RenewType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.licensemanager.model.RenewType.WEEKLY =>
      val r = Weekly
      r
    case software.amazon.awssdk.services.licensemanager.model.RenewType.MONTHLY =>
      val r = Monthly
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.RenewType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.RenewType =
      software.amazon.awssdk.services.licensemanager.model.RenewType.UNKNOWN_TO_SDK_VERSION
  }
  case object None
      extends io.github.vigoo.zioaws.licensemanager.model.RenewType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.RenewType =
      software.amazon.awssdk.services.licensemanager.model.RenewType.NONE
  }
  case object Weekly
      extends io.github.vigoo.zioaws.licensemanager.model.RenewType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.RenewType =
      software.amazon.awssdk.services.licensemanager.model.RenewType.WEEKLY
  }
  case object Monthly
      extends io.github.vigoo.zioaws.licensemanager.model.RenewType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.RenewType =
      software.amazon.awssdk.services.licensemanager.model.RenewType.MONTHLY
  }
}
