package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProductInformation(
    resourceType: String,
    productInformationFilterList: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ProductInformation = {
    import ProductInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProductInformation
      .builder()
      .resourceType(resourceType: java.lang.String)
      .productInformationFilterList(productInformationFilterList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ProductInformation
      .wrap(buildAwsValue())
}
object ProductInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ProductInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ProductInformation =
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation(
        resourceTypeValue,
        productInformationFilterListValue.map { item =>
          item.editable
        }
      )
    def resourceTypeValue: String
    def productInformationFilterListValue: List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly
    ]
    def resourceType: ZIO[Any, Nothing, String] = ZIO.succeed(resourceTypeValue)
    def productInformationFilterList: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly
    ]] = ZIO.succeed(productInformationFilterListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ProductInformation
  ) extends io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly {
    override def resourceTypeValue: String = impl.resourceType(): String
    override def productInformationFilterListValue: List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter.ReadOnly
    ] = impl
      .productInformationFilterList()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.ProductInformationFilter
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ProductInformation
  ): io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly =
    new Wrapper(impl)
}
