package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.{MaxSize100, Arn}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLicenseVersionsRequest(
    licenseArn: Arn,
    nextToken: Option[String] = None,
    maxResults: Option[MaxSize100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest = {
    import ListLicenseVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest
      .wrap(buildAwsValue())
}
object ListLicenseVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest =
      io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest(
        licenseArnValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def licenseArnValue: Arn
    def nextTokenValue: Option[String]
    def maxResultsValue: Option[MaxSize100]
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: Option[MaxSize100] =
      scala.Option(impl.maxResults()).map(value => value: MaxSize100)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListLicenseVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
