package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseUsage(
    entitlementUsages: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseUsage = {
    import LicenseUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseUsage
      .builder()
      .optionallyWith(
        entitlementUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitlementUsages)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseUsage
      .wrap(buildAwsValue())
}
object LicenseUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.LicenseUsage =
      io.github.vigoo.zioaws.licensemanager.model.LicenseUsage(
        entitlementUsagesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def entitlementUsagesValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly
    ]]
    def entitlementUsages: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("entitlementUsages", entitlementUsagesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseUsage
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly {
    override def entitlementUsagesValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly
    ]] = scala
      .Option(impl.entitlementUsages())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseUsage
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly =
    new Wrapper(impl)
}
