package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  BoxLong,
  DateTime
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseConfigurationUsage(
    resourceArn: Option[String] = None,
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    resourceStatus: Option[String] = None,
    resourceOwnerId: Option[String] = None,
    associationTime: Option[DateTime] = None,
    consumedLicenses: Option[BoxLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage = {
    import LicenseConfigurationUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceStatus.map(value => value: java.lang.String))(
        _.resourceStatus
      )
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(associationTime.map(value => value: Instant))(
        _.associationTime
      )
      .optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(
        _.consumedLicenses
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage
      .wrap(buildAwsValue())
}
object LicenseConfigurationUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage =
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage(
        resourceArnValue.map(value => value),
        resourceTypeValue.map(value => value),
        resourceStatusValue.map(value => value),
        resourceOwnerIdValue.map(value => value),
        associationTimeValue.map(value => value),
        consumedLicensesValue.map(value => value)
      )
    def resourceArnValue: Option[String]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def resourceStatusValue: Option[String]
    def resourceOwnerIdValue: Option[String]
    def associationTimeValue: Option[DateTime]
    def consumedLicensesValue: Option[BoxLong]
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceStatus", resourceStatusValue)
    def resourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def associationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("associationTime", associationTimeValue)
    def consumedLicenses: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly {
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def resourceStatusValue: Option[String] =
      scala.Option(impl.resourceStatus()).map(value => value: String)
    override def resourceOwnerIdValue: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def associationTimeValue: Option[DateTime] =
      scala.Option(impl.associationTime()).map(value => value: DateTime)
    override def consumedLicensesValue: Option[BoxLong] =
      scala.Option(impl.consumedLicenses()).map(value => value: BoxLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly =
    new Wrapper(impl)
}
