package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.DateTime
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseConfigurationAssociation(
    resourceArn: Option[String] = None,
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    resourceOwnerId: Option[String] = None,
    associationTime: Option[DateTime] = None,
    amiAssociationScope: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation = {
    import LicenseConfigurationAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(associationTime.map(value => value: Instant))(
        _.associationTime
      )
      .optionallyWith(
        amiAssociationScope.map(value => value: java.lang.String)
      )(_.amiAssociationScope)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation
      .wrap(buildAwsValue())
}
object LicenseConfigurationAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation =
      io.github.vigoo.zioaws.licensemanager.model
        .LicenseConfigurationAssociation(
          resourceArnValue.map(value => value),
          resourceTypeValue.map(value => value),
          resourceOwnerIdValue.map(value => value),
          associationTimeValue.map(value => value),
          amiAssociationScopeValue.map(value => value)
        )
    def resourceArnValue: Option[String]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def resourceOwnerIdValue: Option[String]
    def associationTimeValue: Option[DateTime]
    def amiAssociationScopeValue: Option[String]
    def resourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def associationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("associationTime", associationTimeValue)
    def amiAssociationScope: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("amiAssociationScope", amiAssociationScopeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly {
    override def resourceArnValue: Option[String] =
      scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def resourceOwnerIdValue: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def associationTimeValue: Option[DateTime] =
      scala.Option(impl.associationTime()).map(value => value: DateTime)
    override def amiAssociationScopeValue: Option[String] =
      scala.Option(impl.amiAssociationScope()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly =
    new Wrapper(impl)
}
