package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseUsageResponse(
    licenseUsage: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseUsage
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse = {
    import GetLicenseUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse
      .builder()
      .optionallyWith(licenseUsage.map(value => value.buildAwsValue()))(
        _.licenseUsage
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse
      .wrap(buildAwsValue())
}
object GetLicenseUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseUsageResponse(licenseUsageValue.map(value => value.editable))
    def licenseUsageValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly
    ]
    def licenseUsage: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly
    ] = AwsError.unwrapOptionField("licenseUsage", licenseUsageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly {
    override def licenseUsageValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.ReadOnly
    ] = scala
      .Option(impl.licenseUsage())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseUsage.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly =
    new Wrapper(impl)
}
