package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGrantResponse(
    grant: Option[io.github.vigoo.zioaws.licensemanager.model.Grant] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetGrantResponse = {
    import GetGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetGrantResponse
      .builder()
      .optionallyWith(grant.map(value => value.buildAwsValue()))(_.grant)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse
      .wrap(buildAwsValue())
}
object GetGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetGrantResponse(grantValue.map(value => value.editable))
    def grantValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly]
    def grant: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
    ] = AwsError.unwrapOptionField("grant", grantValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetGrantResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly {
    override def grantValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly] =
      scala
        .Option(impl.grant())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.Grant.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetGrantResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly =
    new Wrapper(impl)
}
