package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExtendLicenseConsumptionRequest(
    licenseConsumptionToken: String,
    dryRun: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest = {
    import ExtendLicenseConsumptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest
      .builder()
      .licenseConsumptionToken(licenseConsumptionToken: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionRequest
      .wrap(buildAwsValue())
}
object ExtendLicenseConsumptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .ExtendLicenseConsumptionRequest(
          licenseConsumptionTokenValue,
          dryRunValue.map(value => value)
        )
    def licenseConsumptionTokenValue: String
    def dryRunValue: Option[Boolean]
    def licenseConsumptionToken: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConsumptionTokenValue)
    def dryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRunValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionRequest.ReadOnly {
    override def licenseConsumptionTokenValue: String =
      impl.licenseConsumptionToken(): String
    override def dryRunValue: Option[Boolean] =
      scala.Option(impl.dryRun()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionRequest.ReadOnly =
    new Wrapper(impl)
}
