package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteGrantResponse(
    grantArn: Option[Arn] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse = {
    import DeleteGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse
      .builder()
      .optionallyWith(grantArn.map(value => value: java.lang.String))(
        _.grantArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse
      .wrap(buildAwsValue())
}
object DeleteGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse =
      io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse(
        grantArnValue.map(value => value),
        statusValue.map(value => value),
        versionValue.map(value => value)
      )
    def grantArnValue: Option[Arn]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus]
    def versionValue: Option[String]
    def grantArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("grantArn", grantArnValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GrantStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly {
    override def grantArnValue: Option[Arn] =
      scala.Option(impl.grantArn()).map(value => value: Arn)
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.GrantStatus.wrap(value)
        )
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly =
    new Wrapper(impl)
}
